import { headers } from "next/headers";
export async function GET() {
  // Get headers using next/headers
  const requestHeaders = headers();
  // Check if the request is coming from localhost (specifically localhost:3000)
  const host = requestHeaders.get("host");
  const domain = host;
  // Fetch your dynamic data (e.g., pages, blog posts, etc.)
  const sitemaps = [
    {
      loc: `https://${domain}/sitemap/pages-sitemap.xml`,
    },
    {
      loc: `https://${domain}/sitemap/blog-sitemap.xml`,
    },
    {
      loc: `https://${domain}/sitemap/projects-sitemap.xml`,
    },
    {
      loc: `https://${domain}/sitemap/developers-sitemap.xml`,
    },
    {
      loc: `https://${domain}/sitemap/types-sitemap.xml`,
    },
  ];
  // Generate the sitemap XML
  const sitemapXml = `<?xml version="1.0" encoding="UTF-8"?>
  <sitemapindex xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
    ${sitemaps
      .map(
        (sitemap) => `
      <sitemap>
        <loc>${sitemap.loc}</loc>
        <lastmod>${new Date().toISOString()}</lastmod>
      </sitemap>
    `
      )
      .join("")}
  </sitemapindex>`;

  // Return the XML as a response
  return new Response(sitemapXml, {
    headers: {
      "Content-Type": "application/xml",
    },
  });
}
