import { localhostdomain, WorkDomain } from "@/app/domain";
import { FetchData } from "@/libs/api";
import { headers } from "next/headers";
export async function GET() {
  // Get headers using next/headers
  const requestHeaders = headers();
  // Check if the request is coming from localhost (specifically localhost:3000)
  const host = requestHeaders.get("host");
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const parameters = "homepage";
  const data = await FetchData(domain, parameters);
  const slug = data?.info?.slug;
  // Fetch your dynamic data (e.g., pages, blog posts, etc.)
  const sitemaps = [
    {
      loc: `https://${domain}`,
    },
    {
      loc: `https://${domain}/about-us`,
    },
    {
      loc: `https://${domain}/contact-us`,
    },
    {
      loc: `https://${domain}/privacy-policy`,
    },
    {
      loc: `https://${domain}/why-invest-in-${slug}`,
    },
  ];
  // Generate the sitemap XML
  const sitemapXml = `<?xml version="1.0" encoding="UTF-8"?>
  <urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd">
    ${sitemaps
      .map(
        ({ loc }) => `
      <url>
        <loc>${loc}</loc>
        <lastmod>${new Date().toISOString()}</lastmod>
      </url>
    `
      )
      .join("")}
  </urlset>`;

  // Return the XML as a response
  return new Response(sitemapXml, {
    headers: {
      "Content-Type": "application/xml",
    },
  });
}
