import dynamic from "next/dynamic";
import { headers } from "next/headers";
import { localhostdomain, WorkDomain } from "../domain";
const ContentSec = dynamic(() => import("@/sections/ContentSec"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
export async function generateMetadata() {
  const requestHeaders = headers();
  const domain = requestHeaders.get("host") || "";
  return {
    metadataBase: new URL(`https://${domain}/about-us`),
    title: `About Us - Experienced Real Estate Professionals | ${domain}`,
    description: `Discover the story behind ${domain}, where experienced real estate professionals work tirelessly to guide you through every step of your property journey. Let us help you make your next move!`,
    keywords: [""],
    alternates: {
      canonical: "/",
    },
    openGraph: {
      url: "/",
    },
  };
}
export default async function page() {
  const requestHeaders = headers();
  const domain = requestHeaders.get("host") || "";
  return (
    <>
      <WebsiteSchema
        title={`About Us - Experienced Real Estate Professionals | ${domain}`}
        description={`Discover the story behind ${domain}, where experienced real estate professionals work tirelessly to guide you through every step of your property journey. Let us help you make your next move!`}
        keywords=""
        fullUrl={`https://${domain}/about-us`}
      />
      <RatingSchema
        title={`About Us - Experienced Real Estate Professionals | ${domain}`}
      />
      <div className="container mt-5">
        <h1>About Us</h1>
      </div>
      <ContentSec
        content={`<p>Welcome to ${domain} , your trusted partner in navigating the real estate market. Whether you're buying, selling, or renting, we are dedicated to providing you with the resources, expertise, and personalized service you need to make informed decisions and achieve your property goals.</p>
<h2>Our Mission</h2>
<p>At ${domain} , our mission is simple: to help you find your dream property or sell your current one with ease and confidence. We are committed to delivering exceptional customer service, reliable advice, and up-to-date market information to guide you every step of the way.</p>
<h3>Why Choose Us?</h3>
<p>With years of experience in the real estate industry, our team understands the complexities of the market and is here to make your experience as smooth as possible. We pride ourselves on:</p>
<ul>
<li><strong>Expert Knowledge:</strong> Our team of professionals is always on top of the latest trends and developments in the real estate industry.</li>
<li><strong>Comprehensive Listings:</strong> We offer an extensive database of properties for sale, rent, and investment opportunities.</li>
<li><strong>Personalized Service:</strong> Every client is unique, and we take the time to understand your needs to offer tailored solutions.</li>
<li><strong>Transparency:</strong> We believe in open communication and provide honest and clear guidance throughout the entire process.</li>
</ul>
<h3>Our Values</h3>
<ul>
<li><strong>Integrity:</strong> We uphold the highest standards of honesty and ethical conduct in all our dealings.</li>
<li><strong>Customer-Centric:</strong> Your satisfaction is our priority, and we work diligently to exceed your expectations.</li>
<li><strong>Innovation:</strong> We utilize cutting-edge tools and technologies to enhance your real estate experience.</li>
</ul>`}
        classCus="mt-0"
      />
    </>
  );
}
