import dynamic from "next/dynamic";
import { localhostdomain, WorkDomain } from "../domain";
import { headers } from "next/headers";
import { FetchData } from "@/libs/api";
import { notFound } from "next/navigation";
const BlogCard = dynamic(() => import("@/components/BlogCard"));
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
export async function generateMetadata() {
  const requestHeaders = headers();
  const host = requestHeaders.get("host") || "";
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const parameter = "blog-list";
  const data = await FetchData(domain, parameter);
  const { meta_title, meta_desc, meta_keywords } = data;
  return {
    metadataBase: new URL(`https://${domain}/blog`),
    title: meta_title,
    description: meta_desc,
    keywords: meta_keywords,
    alternates: {
      canonical: "/",
    },
    openGraph: {
      url: "/",
    },
  };
}
export default async function page() {
  const requestHeaders = headers();
  const host = requestHeaders.get("host") || "";
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const currectUrl = `https://${domain}/blog`;
  const parameter = "blog-list";
  const data = await FetchData(domain, parameter);
  if (!data) {
    notFound();
  }
  const { meta_title, meta_desc, meta_keywords, blogs } = data;
  return (
    <>
      <WebsiteSchema
        title={meta_title}
        description={meta_desc}
        keywords={meta_keywords}
        fullUrl={currectUrl}
      />
      <RatingSchema title={meta_title} />
      {/* <!-- Blog 6 - Bootstrap Brain Component --> */}
      <section className="py-3 py-md-5">
        <div className="container">
          <div className="row justify-content-md-center">
            <div className="col-12 col-md-10 col-lg-10">
              <h1 className="mb-2 display-5 text-center">Our Blogs</h1>
              <p className="text-secondary mb-5 text-center lead fs-6">
                Welcome to our real estate blog, your go-to source for the
                latest market trends, expert insights, and investment
                opportunities. Whether you're a first-time homebuyer, a seasoned
                investor, or simply looking to stay informed, our blog covers
                everything from property guides and community highlights to
                legal updates and market forecasts. Explore valuable tips,
                in-depth analyses, and exclusive updates to make informed
                decisions about buying, selling, or investing in real estate.
                Stay ahead of the market and discover the best opportunities in
                &nbsp;{domain} today!
              </p>
              <hr className="w-50 mx-auto mb-5 mb-xl-9 border-dark-subtle" />
            </div>
          </div>
        </div>
        <div className="container overflow-hidden">
          <div className="row gy-4 gy-xxl-5">
            {blogs.map((items, i) => (
              <BlogCard
                title={items?.title}
                discription={items?.short_content}
                img={items?.cover_image}
                date={items?.posted_date}
                slug={items?.slug}
                key={i}
              />
            ))}
          </div>
        </div>
      </section>
    </>
  );
}
