import dynamic from "next/dynamic";
import { headers } from "next/headers";
const ContactUs = dynamic(() => import("@/sections/ContactUs"));
const Getintu = dynamic(() => import("@/sections/Getintu"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
export async function generateMetadata() {
  const requestHeaders = headers();
  const domain = requestHeaders.get("host") || "";
  return {
    metadataBase: new URL(`https://${domain}/contact-us`),
    title: `Contact Us - Get in Touch with ${domain} | Real Estate Experts`,
    description: `Have questions or need real estate assistance? Contact ${domain} today! Our team is ready to help you buy, sell, or rent properties with personalized guidance and expert advice.`,
    keywords: [""],
    alternates: {
      canonical: "/contact-us",
    },
    openGraph: {
      url: "/",
    },
  };
}
export default function page() {
  const requestHeaders = headers();
  const domain = requestHeaders.get("host") || "";
  return (
    <>
      <WebsiteSchema
        title={`Contact Us - Get in Touch with ${domain} | Real Estate Experts`}
        description={`Have questions or need real estate assistance? Contact ${domain} today! Our team is ready to help you buy, sell, or rent properties with personalized guidance and expert advice.`}
        keywords=""
        fullUrl={`https://${domain}/contact-us`}
      />
      <RatingSchema
        title={`Contact Us - Get in Touch with ${domain} | Real Estate Experts`}
      />
      <ContactUs domain={domain} />
      <Getintu />
    </>
  );
}
