import { headers } from "next/headers";
import dynamic from "next/dynamic";
import { localhostdomain, WorkDomain } from "../domain";
import { FetchData } from "@/libs/api";
const ContentSec = dynamic(() => import("@/sections/ContentSec"));
const DevelopersList = dynamic(() => import("@/sections/DevelopersList"));
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
export async function generateMetadata() {
  const requestHeaders = headers();
  const host = requestHeaders.get("host") || "";
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const first_para = "developers";
  const data = await FetchData(domain, first_para);
  const { meta_title, meta_desc, meta_keywords } = data;
  return {
    metadataBase: new URL(`https://${domain}/developers`),
    title: meta_title,
    description: meta_desc,
    keywords: meta_keywords,
    alternates: {
      canonical: "/",
    },
    openGraph: {
      url: "/",
    },
  };
}
export default async function page() {
  const requestHeaders = headers();
  const host = requestHeaders.get("host") || "";
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const first_para = "developers";
  const data = await FetchData(domain, first_para);
  const {
    meta_title,
    meta_desc,
    meta_keywords,
    short_content,
    heading1,
    full_content,
    developers,
  } = data;
  return (
    <>
      <WebsiteSchema
        title={meta_title}
        description={meta_desc}
        keywords={meta_keywords}
        fullUrl={`https://${domain}/developers`}
      />
      <RatingSchema title={meta_title} />
      <DevelopersList
        developers={developers}
        short_content={short_content}
        heading1={heading1}
      />
      {full_content ? <ContentSec content={full_content} /> : ""}
    </>
  );
}
