import "@/style/_index.scss";
import dynamic from "next/dynamic";
import NextTopLoader from "nextjs-toploader";
import { ModalProvider } from "@/context/ModalContext";
import { CountryProvider } from "@/context/CountryContext";
import { GoogleAnalytics, GoogleTagManager } from "@next/third-parties/google";
import { Lato, Ubuntu } from "next/font/google";
import { FetchData } from "@/libs/api";
import { localhostdomain, WorkDomain } from "./domain";
import { headers } from "next/headers";
const Cta = dynamic(() => import("@/components/layout/Cta"));
const WhatsappBtn = dynamic(() => import("@/components/layout/WhatsappBtn"));
const Header = dynamic(() => import("@/components/layout/Header"));
const Getintu = dynamic(() => import("@/sections/Getintu"));
const lato = Lato({
  subsets: ["latin"],
  weight: ["100", "300", "400", "700", "900"],
  display: "swap",
  variable: "--font_montserrat",
});
const ubuntu = Ubuntu({
  subsets: ["latin"],
  weight: ["300", "400", "700"],
  display: "swap",
  variable: "--font_roboto",
});
export async function generateMetadata() {
  const requestHeaders = headers();
  const host = requestHeaders.get("host") || "";
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const first_para = "homepage";
  const data = await FetchData(domain, first_para);
  const { info = {} } = data ?? {};
  const {
    search_console_code,
    bing,
    yandex,
    meta_index,
    community_name,
    cover_iamge,
  } = info;
  return {
    robots: {
      index: meta_index,
      follow: meta_index,
    },
    openGraph: {
      type: "website",
      siteName: community_name,
      images: {
        url: cover_iamge,
        width: 100,
        height: 100,
      },
    },
    verification: {
      google: search_console_code,
      yandex: yandex,
      other: {
        "msvalidate.01": [bing],
      },
    },
  };
}
export default async function RootLayout({ children }) {
  const requestHeaders = headers();
  const host = requestHeaders.get("host") || "";
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const first_para = "homepage";
  const data = await FetchData(domain, first_para);
  const { info = {}, blog_value = {} } = data ?? {};
  const { google_analytics_id, community_name, google_tag_manager_id } =
    info ?? {};
  return (
    <html lang="en">
      {google_analytics_id ? (
        <GoogleAnalytics gaId={google_analytics_id} />
      ) : (
        ""
      )}
      {google_tag_manager_id ? (
        <GoogleTagManager gtmId={google_tag_manager_id} />
      ) : (
        ""
      )}
      <GoogleTagManager gtmId="GTM-THRD2SKB" />
      <body className={`${lato.variable} ${ubuntu.variable}`}>
        <noscript>
          <iframe
            src="https://www.googletagmanager.com/ns.html?id=GTM-THRD2SKB"
            height="0"
            width="0"
            className="d-none"
          ></iframe>
        </noscript>
        {google_tag_manager_id ? (
          <noscript>
            <iframe
              src={`https://www.googletagmanager.com/ns.html?id=${google_tag_manager_id}`}
              height="0"
              width="0"
              className="d-none"
            ></iframe>
          </noscript>
        ) : (
          ""
        )}

        <CountryProvider>
          <ModalProvider>
            <NextTopLoader
              color="white"
              initialPosition={0.08}
              height={2}
              crawl={true}
              showSpinner={false}
              easing="ease"
              speed={200}
              shadow="0 0 10px white,0 0 5px white"
              template='<div class="bar" role="bar"><div class="peg"></div></div> 
  <div class="spinner" role="spinner"><div class="spinner-icon"></div></div>'
              zIndex={1600}
              showAtBottom={false}
            />
            <Header info={info} domain={domain} blog_value={blog_value} />
            {children}
            <Getintu />
            <div className="container-fluid footer">
              <div className="w-100 d-flex justify-content-center align-items-center p-3 fs-6">
                <a href="/" className="text-white">
                  &copy; {domain}
                </a>
              </div>
            </div>
            <Cta community_name={community_name} domain={domain} />
          </ModalProvider>
        </CountryProvider>
        <WhatsappBtn community_name={community_name} domain={domain} />
      </body>
    </html>
  );
}
