import dynamic from "next/dynamic";
import { localhostdomain, WorkDomain } from "./domain";
import { headers } from "next/headers";
import { FetchData } from "@/libs/api";
const HBlogSec = dynamic(() => import("@/sections/HBlogSec"));
const About2 = dynamic(() => import("@/sections/About2"));
const Gallery = dynamic(() => import("@/sections/Gallery"));
const Hero = dynamic(() => import("@/sections/Hero"));
const Faqs = dynamic(() => import("@/sections/Faqs"));
const FloorPlan = dynamic(() => import("@/sections/FloorPlan"));
const PaymentPlan = dynamic(() => import("@/sections/PaymentPlan"));
const Amenities = dynamic(() => import("@/sections/Amenities"));
const OffPlanCardsSec = dynamic(() => import("@/sections/OffPlanCardsSec"));
const FaqsSchema = dynamic(() => import("@/components/Schema/FaqsSchema"));
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
export async function generateMetadata() {
  const requestHeaders = headers();
  const host = requestHeaders.get("host") || "";
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const first_para = "homepage";
  const data = await FetchData(domain, first_para);
  const { info = {} } = data ?? {};
  const { meta_title, meta_desc, meta_keywords, cover_iamge, community_name } =
    info ?? {};
  return {
    metadataBase: new URL(`https://${domain}`),
    title: meta_title,
    description: meta_desc,
    keywords: meta_keywords,
    alternates: {
      canonical: "/",
    },
    openGraph: {
      type: "website",
      siteName: community_name,
      url: "/",
      images: {
        url: cover_iamge,
        width: 100,
        height: 100,
      },
    },
  };
}
export default async function Home() {
  const requestHeaders = headers();
  const host = requestHeaders.get("host") || "";
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const first_para = "homepage";
  const data = await FetchData(domain, first_para);
  const {
    info,
    apartments,
    townhouses,
    villas,
    interior_gallery,
    exterior_gallery,
    gallery_heading,
    payment_plan,
    faqs,
    floor_plan,
    blog,
  } = data ?? {};
  const {
    meta_title,
    meta_desc,
    meta_keywords,
    community_name,
    short_content,
    about_image,
    cover_iamge,
  } = info ?? {};
  return (
    <>
      <WebsiteSchema
        title={meta_title}
        description={meta_desc}
        keywords={meta_keywords}
        fullUrl={`https://${domain}`}
      />
      <RatingSchema title={meta_title} />
      {faqs?.length > 0 && <FaqsSchema faqs={faqs} />}
      <Hero info={info} cover_iamge={cover_iamge} />
      {short_content?.length > 0 && (
        <About2
          content={short_content}
          img={about_image}
          comuname={community_name}
        />
      )}
      {apartments?.data?.length > 0 && (
        <OffPlanCardsSec
          type="Apartments"
          community_name={community_name}
          data={apartments?.data}
          domain={domain}
          slug={apartments?.slug}
          heading={`Apartments for sale in ${apartments?.data[0]?.community_name}`}
        />
      )}
      {townhouses?.data?.length > 0 && (
        <OffPlanCardsSec
          type="Townhouses"
          community_name={community_name}
          data={townhouses?.data}
          domain={domain}
          slug={townhouses?.slug}
          heading={`Townhouses for sale in ${townhouses?.data[0]?.community_name}`}
        />
      )}
      {villas?.data?.length > 0 && (
        <OffPlanCardsSec
          type="Villas"
          community_name={community_name}
          data={villas?.data}
          domain={domain}
          slug={villas?.slug}
          heading={`Villas for sale in ${villas?.data[0]?.community_name}`}
        />
      )}
      {payment_plan ? (
        <PaymentPlan
          payment_plan={payment_plan}
          community_name={community_name}
        />
      ) : (
        ""
      )}
      <Amenities />
      {floor_plan?.bedroom?.length > 0 && (
        <FloorPlan community_name={community_name} floor_plan={floor_plan} />
      )}
      {(exterior_gallery?.length > 0 || interior_gallery?.length > 0) && (
        <Gallery
          exteriorGallery={exterior_gallery}
          interiorGallery={interior_gallery}
          gallery_heading={gallery_heading}
        />
      )}
      {blog?.length > 0 && <HBlogSec blog={blog} />}
      {faqs?.length > 0 && <Faqs faqs={faqs} />}
    </>
  );
}
