import { headers } from "next/headers";
import dynamic from "next/dynamic";
import { localhostdomain, WorkDomain } from "../domain";
import { FetchData } from "@/libs/api";
import { notFound } from "next/navigation";
const OffPlanCardsList = dynamic(() => import("@/sections/OffPlanCardsList"));
const ContentSec = dynamic(() => import("@/sections/ContentSec"));
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
export async function generateMetadata() {
  const requestHeaders = headers();
  const host = requestHeaders.get("host") || "";
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const first_para = "projects";
  const data = await FetchData(domain, first_para);
  const { meta_title, meta_desc, meta_keywords } = data;
  return {
    metadataBase: new URL(`https://${domain}/projects`),
    title: meta_title,
    description: meta_desc,
    keywords: meta_keywords,
    alternates: {
      canonical: "/",
    },
    openGraph: {
      url: "/",
    },
  };
}
export default async function page() {
  const requestHeaders = headers();
  const host = requestHeaders.get("host") || "";
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const first_para = "projects";
  const data = await FetchData(domain, first_para);
  if (!data) {
    notFound();
  }
  const {
    meta_title,
    meta_desc,
    meta_keywords,
    projects,
    content,
    short_content,
    heading,
  } = data;
  return (
    <>
      <WebsiteSchema
        title={meta_title}
        description={meta_desc}
        keywords={meta_keywords}
        fullUrl={`https://${domain}/projects`}
      />
      <RatingSchema title={meta_title} />
      <OffPlanCardsList
        data={projects}
        heading={heading}
        content={short_content}
        domain={domain}
        cardsQuantity="12"
      />
      <ContentSec content={content} />
    </>
  );
}
