import Image from "next/image";
export default function BlogCard({ title, date, discription, img, slug }) {
  return (
    <>
      <div className="col-12 col-md-6 col-lg-4 d-flex blogcarddh">
        <article className="d-flex">
          <div className="card border border-dark">
            <figure className="card-img-top m-0 overflow-hidden bsb-overlay-hover">
              <a href={`/blog/${slug}`}>
                <Image
                  style={{ height: "250px" }}
                  width={400}
                  height={400}
                  className="img-fluid bsb-scale bsb-hover-scale-up object-fit-cover w-100"
                  loading="lazy"
                  src={img || "/images/noimg.jpg"}
                  alt=""
                />
              </a>
            </figure>
            <div className="card-body border-0 bg-white p-3">
              <div className="entry-header mb-3">
                <ul className="entry-meta list-unstyled d-flex mb-2">
                  <li>
                    <a
                      className="link-dark link-opacity-75 link-opacity-100-hover text-decoration-none"
                      href={`/blog/${slug}`}
                    >
                      <span className="fs-7">{date}</span>
                    </a>
                  </li>
                </ul>
                <h2
                  className="card-title entry-title h4 mb-0"
                  style={{ fontSize: "18px", lineHeight: "27px" }}
                >
                  <a
                    className="link-dark link-opacity-100 link-opacity-75-hover text-decoration-none"
                    href={`/blog/${slug}`}
                  >
                    {title}
                  </a>
                </h2>
              </div>
              <p
                className="card-text entry-summary text-secondary m-0 p-0 blogcarddpara"
                style={{ fontSize: "15px" }}
              >
                {discription}
              </p>
              <h4
                className="h6 text-black bsb-hover-fadeInRight mt-2"
                style={{ fontSize: "18px" }}
              >
                Read More..
              </h4>
            </div>
          </div>
        </article>
      </div>
    </>
  );
}
