"use client";
import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Pagination } from "swiper/modules";
import Image from "next/image";
export default function ImageSlider({ images }) {
  return (
    <>
      <Swiper
        style={{
          "--swiper-navigation-color": "#fff",
          "--swiper-pagination-color": "#fff",
        }}
        navigation={true}
        pagination={{
          clickable: true,
        }}
        modules={[Navigation, Pagination]}
        className="mySwiper ourswiper h-100"
      >
        {images.map((item, i) => (
          <SwiperSlide key={i}>
            <Image
              {...(i === 0 ? { priority: true } : { loading: "lazy" })}
              width={700}
              height={700}
              src={item.image || "/images/noimg.jpg"}
              alt={`Slide ${i + 1}`}
              className="w-100 h-100 object-fit-cover"
            />
          </SwiperSlide>
        ))}
      </Swiper>
    </>
  );
}
