const InputField = ({ label, type, name, register, errors, placeholder }) => {
  return (
    <div className="mb-3">
      <div className="form-group">
        <input
          type={type}
          className={`form-control ${errors[name] ? "is-invalid" : ""}`}
          placeholder={placeholder}
          {...register}
        />
        {errors[name] && <p className="text-danger">{errors[name].message}</p>}
      </div>
    </div>
  );
};

export default InputField;
