import { FaWhatsapp } from "react-icons/fa";
import { IoBedOutline, IoLocationOutline } from "react-icons/io5";
import { SlSizeFullscreen } from "react-icons/sl";
import { HiOutlineMail } from "react-icons/hi";
import Image from "next/image";
import { useModal } from "@/context/ModalContext";
import Link from "next/link";
const OffPlanCard = ({
  types,
  bedroom,
  img,
  price,
  location,
  property_name,
  size,
  developer,
  slug,
  domain,
  usps1,
  usps2,
}) => {
  const { toggleModal } = useModal();
  return (
    <div className="new-card m-2">
      {usps1 ? <div className="usps">{usps1}</div> : ""}
      {usps2 ? <div className="usps usps1">{usps2}</div> : ""}
      <Link href={`/projects/${slug}`}>
        <Image
          src={img || "/images/noimg.jpg"}
          alt={property_name}
          className="new-card__image"
          width={400}
          height={300}
        />
      </Link>
      <div className="new-card__content">
        <Link href={`/projects/${slug}`}>
          <h3 className="new-card__title">{property_name}</h3>
          <p className="new-card__details price text-dark">{price}</p>
          <p className="new-card__details d-flex align-items-center gap-2">
            <IoBedOutline /> {bedroom} <SlSizeFullscreen /> {size}
          </p>
          <p className="new-card__details">
            <IoLocationOutline /> {location}
          </p>
        </Link>
        <div className="new-card__button-group">
          <button
            onClick={() =>
              toggleModal(
                "Need Prompt Consultation?",
                property_name,
                price,
                bedroom,
                size,
                location,
                types,
                developer,
                `https://${domain}/projects/${slug}`
              )
            }
          >
            <HiOutlineMail /> Email
          </button>
          <a
            href={`https://wa.me/971524474422?text=Hi+There%2C+I%27m+interested+in+${property_name}.+Kindly+send+me+more+information.+Thank+you%21+https://${domain}/projects/${slug}&type=phone_number&app_absent=0`}
          >
            <button>
              <FaWhatsapp /> Whatsapp
            </button>
          </a>
          <Link href={`/projects/${slug}`}>
            <button>More...</button>
          </Link>
        </div>
      </div>
    </div>
  );
};

export default OffPlanCard;
