export default function BuyListing({
  title,
  description,
  bedroom,
  price,
  size,
  url,
  longitude,
  latitude,
}) {
  const Json = {
    "@context": "https://schema.org",
    "@type": "Offer",
    itemOffered: {
      "@type": "SingleFamilyResidence",
      name: title,
      description: description,
      address: {
        "@type": "PostalAddress",
        streetAddress: "",
        addressLocality: "Business Bay",
        addressRegion: "Dubai",
        postalCode: "",
        addressCountry: "UAE",
      },
      numberOfRooms: bedroom,
      floorSize: {
        "@type": "QuantitativeValue",
        value: size,
        unitCode: "SQFT",
      },
      geo: {
        "@type": "GeoCoordinates",
        latitude: latitude,
        longitude: longitude,
      },
    },
    priceCurrency: "AED",
    price: price,
    url: url,
  };
  return (
    <script
      type="application/ld+json"
      dangerouslySetInnerHTML={{ __html: JSON.stringify(Json) }}
    />
  );
}
