"use client";
import { FaPhoneAlt } from "react-icons/fa";
import { MdEmail } from "react-icons/md";
import { FaWhatsapp } from "react-icons/fa";
import { useModal } from "@/context/ModalContext";
import { useEffect, useState } from "react";
export default function Cta({ community_name }) {
  const { toggleModal } = useModal();
  const [currentURL, setCurrentURL] = useState("");
  useEffect(() => {
    setCurrentURL(window.location.href);
  }, []);
  return (
    <>
      <div className="custom-bottom-nav">
        <div className="custom-nav-menu">
          <a
            className="custom-nav-item"
            onClick={() => toggleModal("Request Callback")}
          >
            <FaPhoneAlt className="custom-icon" />
            <span>CALL US</span>
          </a>
          <a
            className="custom-nav-item"
            onClick={() => toggleModal("ENQUIRE NOW")}
          >
            <MdEmail className="custom-icon" />
            <span>ENQUIRE NOW</span>
          </a>
          <a
            href={`https://wa.me/971524474422?text=Hi+There+Im+interested+in+${community_name}+Kindly+send+me+more+information.+Thank+you+${currentURL}&type=phone_number&app_absent=0`}
            target="_blank"
            rel="noopener noreferrer"
            className="custom-nav-item"
          >
            <FaWhatsapp className="custom-icon" />
            <span>WHATSAPP</span>
          </a>
        </div>
      </div>
    </>
  );
}
