import dynamic from "next/dynamic";
import Image from "next/image";
import Link from "next/link";
const MobileNav = dynamic(() => import("./MobileNav"));
const HeaderWhatsApp = dynamic(() => import("./HeaderWhatsApp"));
export default function Header({ info, domain, blog_value }) {
  const { logo_image, slug, community_name } = info ?? {};
  return (
    <>
      <header className="DetailHeader-container py-0">
        <div className="d-none d-lg-block d-xl-block">
          <nav className="navbar navbar-expand-lg navbar-dark p-0">
            <a className="navbar-brand" href="/">
              <Image
                src={logo_image}
                width={300}
                height={300}
                priority={true}
                alt="logo"
                className="logo_img"
              />
            </a>
            <button
              className="navbar-toggler"
              type="button"
              data-toggle="collapse"
              data-target="#navbarNav"
              aria-controls="navbarNav"
              aria-expanded="false"
              aria-label="Toggle navigation"
            >
              <span className="navbar-toggler-icon"></span>
            </button>
            <div className="collapse navbar-collapse" id="navbarNav">
              <ul className="navbar-nav ml-auto text-uppercase">
                <li className="nav-item">
                  <Link className="nav-link ms-5" href="/">
                    HOME
                  </Link>
                </li>
                <li className="nav-item">
                  <Link className="nav-link" href={`/why-invest-in-${slug}`}>
                    Why Invest
                  </Link>
                </li>
                <li className="nav-item">
                  <Link className="nav-link" href="/projects">
                    Projects
                  </Link>
                </li>
                <li className="nav-item">
                  <Link className="nav-link" href={`/developers`}>
                    Developers
                  </Link>
                </li>
                {blog_value === 1 ? (
                  <li className="nav-item">
                    <Link className="nav-link" href={`/blog`}>
                      Blog
                    </Link>
                  </li>
                ) : (
                  ""
                )}
                <li className="nav-item">
                  <Link className="nav-link" href={`/about-us`}>
                    About Us
                  </Link>
                </li>
                <li className="nav-item">
                  <Link className="nav-link" href="/privacy-policy">
                    Privacy Policy
                  </Link>
                </li>
                <li className="nav-item">
                  <Link className="nav-link" href="/contact-us">
                    Contact
                  </Link>
                </li>
              </ul>
            </div>
            <HeaderWhatsApp community_name={community_name} />
          </nav>
        </div>
        <MobileNav info={info} />
      </header>
    </>
  );
}
