"use client";
import { IoMdClose } from "react-icons/io";
import { RiMenu3Fill } from "react-icons/ri";
import Link from "next/link";
import { useState } from "react";
import Image from "next/image";
export default function MobileNav({ info }) {
  const { logo_image, slug } = info ?? {};
  const [navState, SetnavState] = useState(false);
  return (
    <>
      <div className="mobile_header d-block d-lg-none d-xl-none">
        <div className="container-fluid p-0">
          <div className="col-12 d-flex justify-content-between px-4 py-2 header-pading align-items-center">
            <a href="/">
              <Image
                src={logo_image}
                width={200}
                height={80}
                alt="logo2"
                className="Mlogo_img"
              />
            </a>
            <div className="toggle_menu">
              <RiMenu3Fill onClick={() => SetnavState(true)} />
            </div>
          </div>
        </div>
        <div className={`menu ${navState ? "menu-visible" : ""}`}>
          <IoMdClose onClick={() => SetnavState(false)} />
          <ul className="menu-inner">
            <li className="menu-item">
              <a href="/" className="menu-logo">
                <Image
                  src={logo_image}
                  width={200}
                  height={80}
                  alt="logo"
                  className="logo_img"
                />
              </a>
            </li>
            <li className="menu-item">
              <Link href="/" className="menu-link">
                Home
              </Link>
            </li>
            <li className="menu-item">
              <Link href={`/why-invest-in-${slug}`} className="menu-link">
                Why Invest
              </Link>
            </li>
            <li className="menu-item">
              <Link href="/projects" className="menu-link">
                Projects
              </Link>
            </li>
            <li className="menu-item">
              <Link href="/blog" className="menu-link">
                Blog
              </Link>
            </li>
            <li className="menu-item">
              <Link className="menu-link" href={`/developers`}>
                Developers
              </Link>
            </li>
            <li className="menu-item">
              <Link href="/about-us" className="menu-link">
                About Us
              </Link>
            </li>
            <li className="menu-item">
              <Link href="/privacy-policy" className="menu-link">
                Privacy Policy
              </Link>
            </li>
            <li className="menu-item">
              <Link className="menu-link" href="/contact-us">
                Contact
              </Link>
            </li>
          </ul>
        </div>
      </div>
    </>
  );
}
