"use client";
import { fetchCountry } from "@/libs/api";
import { createContext, useContext, useEffect, useState } from "react";
const CountryContext = createContext();
export const CountryProvider = ({ children }) => {
  const [country, setCountry] = useState(null);
  useEffect(() => {
    async function getCountry() {
      try {
        const fetchedCountry = await fetchCountry();
        if (fetchedCountry === null) {
          setCountry("ae");
        } else {
          setCountry(fetchedCountry);
        }
      } catch (error) {
        if (error) {
          setCountry("ae");
        }
        console.error("Error fetching country:", error);
      }
    }
    getCountry();
  }, []); // Empty dependency array means it runs once when the component mounts
  return (
    <CountryContext.Provider value={country}>
      {children}
    </CountryContext.Provider>
  );
};
export const useCountry = () => useContext(CountryContext);
