import axios from "axios";
const APIKEY = process.env.NEXT_PUBLIC_API_KEY;
export async function FetchData(domain, first_para, secparams = "") {
  const apiURL = `https://api.uae-offplan.com/api/${domain}/${first_para}/${secparams}`;
  // const apiURL = `http://192.168.18.9:8000/api/${domain}/${first_para}/${secparams}`;
  try {
    const response = await axios.get(apiURL, {
      headers: {
        Authorization: `Bearer ${APIKEY}`,
      },
    });
    return response.data; // Return the data
  } catch (error) {
    console.error("Error fetching data:", error);
    return null; // Handle error by returning null or an empty object
  }
}
const NEXT_COUNTRY_API_KEY = process.env.NEXT_PUBLIC_COUNTRY_API_KEY;
const CURRENT_COUNTRY_URL = `https://ipinfo.io/?token=${NEXT_COUNTRY_API_KEY}`;
export const fetchCountry = async () => {
  try {
    const response = await axios.get(CURRENT_COUNTRY_URL);
    return response?.data?.country?.toLowerCase() || null;
  } catch (error) {
    console.error("Error fetching current country info:", error);
    return null;
  }
};
