import Image from "next/image";

export default function About2({ comuname, img, content }) {
  return (
    <>
      <section>
        <div className="container">
          <div className="row">
            <div className="col-lg-6">
              <Image
                src={img || "/images/overview.png"}
                alt={comuname}
                priority={true}
                width={700}
                height={700}
                className="w-100 object-fit-cover h-100"
              />
            </div>
            <div className="col-lg-6 mt-3">
              <h2 className="mb-3">
                Properties for sale in
                <br /> {comuname}
              </h2>
              <div dangerouslySetInnerHTML={{ __html: content }} />
            </div>
          </div>
        </div>
      </section>
    </>
  );
}
