import { amenities } from "@/data/data";
import CardComponent from "@/components/CardComponent";
export default function Amenities({ data }) {
  return (
    <>
      <section className="Amenities">
        <h2 className="text-center mb-4">Amenities</h2>
        <div className="container">
          <div className="row">
            {data ? (
              <>
                {data?.map((amenity, i) => (
                  <div className="col-lg-2 col-md-4 col-sm-6 col-6" key={i}>
                    <CardComponent
                      heading={amenity?.name}
                      icon={amenity?.icon}
                    />
                  </div>
                ))}
              </>
            ) : (
              <>
                {amenities?.map((amenity, i) => (
                  <div className="col-lg-2 col-md-4 col-sm-6 col-6" key={i}>
                    <CardComponent
                      heading={amenity?.amenity_name}
                      icon={amenity?.amenity_icon}
                    />
                  </div>
                ))}
              </>
            )}
          </div>
        </div>
      </section>
    </>
  );
}
