"use client";
import { useModal } from "@/context/ModalContext";
import Image from "next/image";
export default function FeatureProperty() {
  const heading = "COMING SOON";
  const { toggleModal } = useModal();
  const FeatureProperty = [
    {
      img: "/images/Clip-path-group-7.webp",
      title: "Villas For Sale",
    },
    { img: "/images/Group-68.webp", title: "Plots For Sale" },
    {
      img: "/images/Clip-path-group-8.webp",
      title: "Townhouse For Sale",
    },
  ];
  return (
    <section>
      <div className="container text-center ideal-home-container">
        <div className="container text-center">
          <h2 className="ideal-home-title">FEATURED PROPERTIES</h2>
          <div className="row">
            {FeatureProperty.map((item, index) => (
              <div className="col-lg-4 col-sm-12 mb-4" key={index}>
                <div className="ideal-home-property-card">
                  <div className="ideal-home-image-container">
                    <Image
                      width={451}
                      height={250}
                      src={item?.img} // dynamically change image based on index
                      alt=""
                      n
                      className="ideal-home-property-image img-fluid"
                    />
                  </div>
                  <div className="ideal-home-property-details">
                    <div>
                      <h3>{heading}</h3>
                    </div>
                  </div>
                </div>
                <h2 className="mt-1" style={{ fontSize: "25px !important" }}>
                  {item?.title}
                </h2>
                <a onClick={() => toggleModal("Enquire Now!")}>
                  <button className="webbutton mt-1">Enquire Now!</button>
                </a>
              </div>
            ))}
          </div>
        </div>
      </div>
    </section>
  );
}
