"use client";
import React, { useState, useRef, useEffect } from "react";
import { RxDimensions } from "react-icons/rx";
import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation } from "swiper/modules";
import { useModal } from "@/context/ModalContext";
import Image from "next/image";
export default function FloorPlanDetail({ property_name = "", Floor_plan }) {
  const { toggleModal } = useModal();
  const [activeIndex, setActiveIndex] = useState(0);
  const swiperRef = useRef(null);

  // Ensure Floor_plan exists before accessing its properties
  const floorPlanKeys = Floor_plan ? Object.keys(Floor_plan) : [];
  const tabs = floorPlanKeys.map((key) => Floor_plan[key].bedroom);

  const handleTabClick = (index) => {
    setActiveIndex(index);
    if (swiperRef.current) {
      swiperRef.current.slideTo(index);
    }
  };

  return (
    <>
      <section id="floor-plan">
        <div className="FloorPlan">
          <div className="container">
            <h5 className="text-center mb-4">{property_name} Floor Plan</h5>
            <p className="text-center para">
              {property_name} understands that one size doesn’t fit all. That’s
              why we offer a variety of spacious plots designed to accommodate
              diverse lifestyles.
            </p>
            <div className="floor-plan mt-5">
              {/* Tabs */}
              <div className="tabs-container">
                {tabs.map((tab, index) => (
                  <button
                    key={index}
                    className={`${
                      index === activeIndex ? "activebutton" : "webbutton"
                    }`}
                    onClick={() => handleTabClick(index)}
                  >
                    <strong>{tab || "Update Soon"}</strong>
                  </button>
                ))}
              </div>

              {/* Dropdown (for smaller screens) */}
              <div className="dropdown mb-4">
                <button
                  className="dropdown-toggle w-100 webbutton"
                  type="button"
                  data-bs-toggle="dropdown"
                  aria-expanded="false"
                >
                  Choose A Bedroom ↓
                </button>
                <ul className="dropdown-menu w-100">
                  {tabs.map((tab, index) => (
                    <li key={index}>
                      <a
                        className="dropdown-item"
                        href="#!"
                        onClick={(e) => {
                          e.preventDefault();
                          handleTabClick(index);
                        }}
                      >
                        {tab || "Update Soon"}
                      </a>
                    </li>
                  ))}
                </ul>
              </div>

              {/* Swiper Carousel */}
              <Swiper
                modules={[Navigation]}
                spaceBetween={10}
                slidesPerView={1}
                navigation={{ clickable: true }}
                onSwiper={(swiper) => (swiperRef.current = swiper)}
                onSlideChange={(swiper) => setActiveIndex(swiper.activeIndex)}
              >
                {floorPlanKeys.map((key, index) => (
                  <SwiperSlide key={index}>
                    <div className="container floorPlancon">
                      <div className="row">
                        {/* Image Section */}
                        <div className="col-md-6">
                          <div className="image-container">
                            <a href="#modal-fp">
                              <Image
                                height={400}
                                width={400}
                                src="/images/FloorPlan.webp"
                                alt="Floor Plan"
                              />
                            </a>
                          </div>
                        </div>

                        {/* Details Section */}
                        <div className="col-md-6 d-flex align-items-center">
                          <div className="details">
                            <h3 className="mb-0">
                              {Floor_plan[key].property_name}
                            </h3>
                            <h4 className="mb-0">
                              <strong>{Floor_plan[key].bedroom}</strong>
                            </h4>
                            <h4>
                              <strong>{Floor_plan[key].starting_price}</strong>
                            </h4>
                            <p>
                              <RxDimensions />
                              &nbsp; &nbsp;<strong>Total Area:</strong>{" "}
                              {Floor_plan[key].total_area || "N/A"}
                            </p>
                            <div className="buttons">
                              <button
                                className="webbutton me-2"
                                onClick={() =>
                                  toggleModal("Get All Floor Plans", {
                                    property_name,
                                  })
                                }
                              >
                                Get All Floor Plans
                              </button>
                              <button
                                className="webbutton btn-dark btn m-0"
                                onClick={() =>
                                  toggleModal("Download Brochure →", {
                                    property_name,
                                  })
                                }
                              >
                                Download Brochure &nbsp;→
                              </button>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </SwiperSlide>
                ))}
              </Swiper>
            </div>
          </div>
        </div>
      </section>
    </>
  );
}
