import { MdCall, MdLocationOn } from "react-icons/md";
import DetailsSection from "@/components/DetailsSection";
import DescriptionSection from "@/components/DescriptionSection";
import Form from "@/components/Form";
import ImageSlider from "@/components/ImageSlider";
import Link from "next/link";
export default function HeroDetail({ data, currectUrl, images }) {
  const {
    property_name,
    community_name,
    heading,
    type_names,
    bedrooms,
    full_content,
    minimum_price,
    min_size,
    usps,
  } = data;
  return (
    <>
      <section className="pt-3">
        <div className="property-list-data">
          <div className="container">
            <div className="propertydetails">
              <h1>{heading || property_name}</h1>
              <Link href="/">
                <p className="text-black">
                  <MdLocationOn /> {community_name}
                </p>
              </Link>
            </div>
            <div className="row">
              <div className="col-lg-8 col-md-12" id="gallery">
                <div className="property-image">
                  <ImageSlider images={images} />
                </div>
                <div className="property-info">
                  <div className="info-item">
                    <p>{usps}</p>
                  </div>
                </div>
                <DetailsSection
                  price={minimum_price}
                  size={min_size}
                  bedroom={bedrooms}
                  community_name={community_name}
                  type={type_names}
                />
                {full_content.length > 0 && (
                  <DescriptionSection description={full_content} />
                )}
              </div>
              <div className="col-lg-4">
                <div className="property-details">
                  <div className="price-set property-price text-center">
                    <span>{minimum_price}</span>
                  </div>
                  <div className="btnscontact d-flex">
                    <a
                      href={`https://wa.me/971524474422?text=Hi+There%2C+I%27m+interested+in+${property_name}.+Kindly+send+me+more+information.+Thank+you%21+${currectUrl}&type=phone_number&app_absent=0`}
                    >
                      <button className="webbutton w-60 whatsappbtn">
                        <svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="20"
                          height="20"
                          data-name="Group 5"
                          viewBox="0 0 20 20"
                          className="_52602d23"
                        >
                          <path fill="none" d="M0 0h20v20H0z"></path>
                          <path
                            fill="#4caf50"
                            d="M10 3.6a6.4 6.4 0 0 0-5.18 10.15l-.8 2.38 2.46-.79A6.4 6.4 0 1 0 10 3.6z"
                          ></path>
                          <path
                            fill="#fafafa"
                            d="M13.83 12.72a1.86 1.86 0 0 1-1.3.93c-.34.08-.79.13-2.3-.5a8.26 8.26 0 0 1-3.27-2.9 3.79 3.79 0 0 1-.78-2 2.12 2.12 0 0 1 .67-1.61.95.95 0 0 1 .67-.24h.22c.2.02.3.03.42.34l.6 1.43a.4.4 0 0 1 .02.35 1.14 1.14 0 0 1-.21.3c-.1.12-.2.2-.29.32-.09.1-.19.22-.08.42a5.87 5.87 0 0 0 1.07 1.33 4.83 4.83 0 0 0 1.54.96.41.41 0 0 0 .47-.08 8 8 0 0 0 .51-.68.37.37 0 0 1 .47-.15c.18.07 1.12.53 1.32.63s.32.14.36.23a1.66 1.66 0 0 1-.11.92z"
                          ></path>
                        </svg>
                        WhatsApp
                      </button>
                    </a>
                    <a href="tel:971524474422">
                      <button className="webbutton w-40 callbtn">
                        <MdCall />
                        Call
                      </button>
                    </a>
                  </div>
                  <Form
                    looking_for={property_name}
                    price={minimum_price}
                    property_name={property_name}
                    unit_type={type_names}
                    bedroom={bedrooms}
                    size={min_size}
                    community_name={community_name}
                    modal=""
                  />
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
}
