import dynamic from "next/dynamic";
const CardComponent = dynamic(() => import("@/components/CardComponent"));
const FormBtn = dynamic(() => import("@/components/FormBtn"), {
  ssr: false,
});
export default function PaymentPlan({ payment_plan, community_name }) {
  const { on_booking, on_construction, on_handover, content } = payment_plan;
  return (
    <>
      <section className="PaymentPlan" id="payment-plan">
        <h2 className="text-center mb-4">
          {community_name} Prices and Payment Plan
        </h2>
        <p className="text-center para">{content}</p>
        <div className="container mt-5 text-center">
          <div className="row justify-content-center ">
            <div className="col-md-3 col-sm-6 col-12">
              <CardComponent
                heading={"On Booking"}
                icon="/images/money.png"
                price={on_booking}
              />
            </div>
            <div className="col-md-3 col-sm-6 col-12">
              <CardComponent
                heading={"During Construction"}
                icon="/images/construction.png"
                price={on_construction}
              />
            </div>
            <div className="col-md-3 col-sm-6 col-12">
              <CardComponent
                heading={"Post Handover"}
                icon="/images/user-hand.png"
                price={on_handover}
              />
            </div>
          </div>
          <a>
            <FormBtn
              className="webbutton mt-3 mx-auto"
              modaltitle="Price Available Units"
            />
          </a>
        </div>
      </section>
    </>
  );
}
